package com.bxm.lovelink.common.dal.entity.dto.activity.organizer;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class ActivityOrganizerDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 城市code
     */
    @NotBlank(message = "城市不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String cityCode;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String name;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String mobile;

    /**
     * 身份信息
     */
    @NotBlank(message = "身份信息不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String cardMessage;

    /**
     * 地址
     */
    @NotBlank(message = "地址不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String address;


    /**
     * 支持活动类型
     */
    @NotBlank(message = "支持活动类型不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String supportActivityTypes;
}
