package com.bxm.lovelink.common.dal.entity.dto.activity.type;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class ActivityTypeDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 1 线上 2线下
     */
    @NotNull(message = "活动类型不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Integer type;

    /**
     * 活动业务类型(能否互选) 0-其他(非互选) 1-互选
     */
    @NotNull(message = "活动业务类型(能否互选)不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Integer bizType;
    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @Length(max = 20, message = "活动类型名称长度不能超过20", groups = {InsertGroup.class, UpdateGroup.class})
    private String name;

    /**
     * 说明
     */
    @NotBlank(message = "活动简介不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String intro;


}
