package com.bxm.lovelink.common.dal.entity.dto.activity.usermutualselection;

import com.bxm.lovelink.common.utils.BitCalculateUtils;
import lombok.Data;
import lombok.Getter;
import lombok.experimental.Accessors;
import org.apache.commons.collections.CollectionUtils;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dll
 * @date 2025/6/25
 */
@Data
@Accessors(chain = true)
public class ActivityMutualSelectionQueryDto{

    /**
     * 活动 id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     *  tab类型 1-心动我的 2-我心动的
     */
    private Integer tabType;

    /**
     * 认证状态 1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    private List<Integer> certStatusList;

    private Integer bitmask;

    private Long userId;

    public Integer getBitmask() {
        if (CollectionUtils.isNotEmpty(certStatusList)) {
            return BitCalculateUtils.calculate(certStatusList);
        }
        return null;
    }

    public interface TabType {
        Integer HEART_ME = 1;
        Integer MY_HEART = 2;
    }
}
