package com.bxm.lovelink.common.dal.entity.dto.application;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author daill
 * @date 2024/3/15
 */
@Data
public class AiApplacationDto {

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;
    /**
     * 应用名称
     */
    @NotBlank(message = "应用名称不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @Length(max = 20, message = "应用名称长度不能超过20", groups = {InsertGroup.class, UpdateGroup.class})
    private String applicationName;


    /**
     * 应用介绍
     */
    private String applicationDescription;


    /**
     * 对应百炼应用ID
     */
    @NotBlank(message = "appId不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String appId;

    /**
     * 业务空间ID
     */
    @NotBlank(message = "workspaceId不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String workspaceId;
}
