package com.bxm.lovelink.common.dal.entity.dto.channel;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class AiChannelDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 父渠道ID
     */
    private Long parentChannelId =0L;

    /**
     * 渠道类型
     */
    //@NotBlank(message = "渠道类型不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private String channelType;
    /**
     * 渠道类型名称（字典）
     */
    //@NotBlank(message = "渠道类型名称不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private String channelTypeName;
    /**
     * 渠道名称
     */
    //@NotBlank(message = "渠道名称不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private String channelName;

    /**
     * 落地页
     */
    //@NotBlank(message = "落地页不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private String url;

    /**
     * 公司名称
     */
    private String company;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 对接员工
     */
    private String bxmBd;

}
