package com.bxm.lovelink.common.dal.entity.dto.chat;

import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/6/30
 */
@Data
public class ApiChatDto {

    /**
     * 对话场景。chat、matching_analysis
     */
    @NotBlank(message = "场景不能为空")
    @Pattern(regexp = "^(app_chat|app_match_analysis)$", message = "场景错误")
    private String scene;

    /**
     * 当对话场景是matching_analysis时，该字段为被匹配的用户id
     */
    private Long taUserId;

    /**
     * 消息类型。0 截断符号、1 文本消息、2 图文、3 用户卡片
     */
    private Integer contentType = 1;

    /**
     * 正文内容
     */
    private String content;

    /**
     * 附件内容，JSON数据，一般根据消息类型来定义自己的数据模型
     */
    private String attachments;

    public ChatSessionMessage to() {
        return new ChatSessionMessage()
                .setContentType(contentType)
                .setContent(content)
                .setAttachments(attachments);
    }
}
