package com.bxm.lovelink.common.dal.entity.dto.chat;

import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author tangxiao
 * @date 2025/6/28
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class ChatDto {
    /**
     * 会话id
     */
    @NotNull(message = "sessionId不能为空")
    private Long sessionId;

    /**
     * 说话人角色：
     * user(App用户) / staff (人工)
     */
    private String role = Constants.Chat.ROLE_STAFF;

    /**
     * 消息类型。0 截断符号、1 文本消息、2 图文、3 用户卡片
     */
    private Integer contentType = 1;

    /**
     * 正文内容
     */
    @NotBlank(message = "content不能为空")
    private String content;

    /**
     * 附件内容，JSON数据，一般根据消息类型来定义自己的数据模型
     */
    private String attachments;

    public ChatSessionMessage to() {
        return new ChatSessionMessage()
                .setContentType(contentType)
                .setContent(content)
                .setAttachments(attachments);
    }
}