package com.bxm.lovelink.common.dal.entity.dto.event;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 事件管理表
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class AiEventDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 事件类型ID
     */
    @NotNull(message = "事件类型不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Integer eventTypeId;

    /**
     * 应用id
     */
    @NotNull(message = "应用不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Long applicationId;

    /**
     * 事件名称
     */
    @NotBlank(message = "事件名称不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @Length(max = 20, message = "事件名称长度不能超过20", groups = {InsertGroup.class, UpdateGroup.class})
    private String name;


    /**
     * 事件说明
     */
    @Length(max = 50, message = "事件说明长度不能超过50", groups = {InsertGroup.class, UpdateGroup.class})
    private String instru;

    /**
     * 背景
     */
    @NotBlank(message = "沟通背景不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String background;

    /**
     * 目标
     */
    @NotBlank(message = "沟通目标不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String target;

}
