package com.bxm.lovelink.common.dal.entity.dto.event;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class AiEventTypeDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;
    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @Length(max = 20, message = "名称长度不能超过20", groups = {InsertGroup.class, UpdateGroup.class})
    private String name;

    /**
     * 说明
     */
    @NotBlank(message = "说明不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String instru;


}
