package com.bxm.lovelink.common.dal.entity.dto.example;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 示例库
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class AiExampleDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 事件ID
     */
    @NotNull(message = "事件id不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Long eventId;

    /**
     * 对话人ID
     */
    @NotNull(message = "对话人ID不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Long interlocutorsId;

    /**
     * 资料状态模版ID
     */
    private Long dataTemId;

    /**
     * 社交状态模版ID
     */
    private Long socializeTemId;

    /**
     * 付费状态模版ID
     */
    private Long payTemId;

    /**
     * 活跃状态模版ID
     */
    private Long actTemId;

    /**
     * 聊天数量
     */
    private Integer chatCount;

    /**
     * 聊天json
     */
    private String chatJson;

    /**
     * 示例标题
     */
    private String exampleTitle;

    /**
     * 示例标签
     */
    private String exampleTag;

    /**
     * 示例简介
     */
    private String exampleIntro;
}
