package com.bxm.lovelink.common.dal.entity.dto.heartbeat;

import lombok.Data;

import java.io.Serializable;
import javax.validation.constraints.NotNull;


/**
 * 心动/不喜欢操作对象
 */
@Data
public class HeartBeatDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 目标用户 ID
     */
    @NotNull(message = "目标用户ID不能为空")
    private Long targetUserId;

    /**
     * 类型 0-未反馈 1= 心动，2= 不喜欢
     */
    @NotNull(message = "类型不能为空")
    private Integer type;

    /**
     * 渠道 1-首页 2-心动列表 默认是首页
     */
    @NotNull(message = "渠道不能为空")
    private Integer channel = 1;
}
