package com.bxm.lovelink.common.dal.entity.dto.heartbeat;

import com.bxm.lovelink.common.dal.entity.base.PageRequest;
import com.bxm.lovelink.common.utils.BitCalculateUtils;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;


/**
 * 查询心动列表
 */
@Data
public class HeartBeatQueryDto extends PageRequest {

    /**
     * 当前用户 ID
     */
    private Long userId;

    /**
     * 经度
     */
    private Double lon;

    /**
     * 维度
     */
    private Double lat;

    /**
     * 房子情况 2、有房，4、无房
     */
    private Integer house;

    /**
     * 车情况 2、有车，4、无车
     */
    private Integer car;

    /**
     * 认证状态 1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    private List<Integer> certStatusList;

    /**
     * 排序字段 TIME心动时间 DISTANCE距离 AGE年龄 PASSIVE_LOVE_COUNT被心动次数 MATCH_SCORE匹配分
     * 距离排序时，经纬度必填
     */
    private String orderBy = OrderByEnum.TIME.value;

    private Integer bitmask;


    @Getter
    public enum OrderByEnum {
        TIME("TIME"),
        DISTANCE("DISTANCE"),
        AGE("AGE"),
        PASSIVE_LOVE_COUNT("PASSIVE_LOVE_COUNT"),
        MATCH_SCORE("MATCH_SCORE");
        private final String value;
        OrderByEnum(String value) {
            this.value = value;
        }
    }

    public Integer getBitmask() {
        if (CollectionUtils.isNotEmpty(certStatusList)) {
            return BitCalculateUtils.calculate(certStatusList);
        }
        return null;
    }
}
