package com.bxm.lovelink.common.dal.entity.dto.meet;

import com.google.common.collect.Lists;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 选择见面地址
 *
 * @author Allen Hu
 * @date 2025/5/13
 */
@Data
public class MeetGroupAddressSelectDto {

    /**
     * 见面群ID
     */
    @NotNull(message = "请选择见面群ID")
    private Long meetGroupId;

    /**
     * 见面地址
     */
    @NotBlank(message = "请填写见面地址")
    private String meetAddress;

    /**
     * 期望的见面时间段，多个用英文逗号隔开。如：2025-11-12 09:00-10:00,2025-11-13 09:00-10:00
     */
    @NotBlank(message = "请填写见面时间段")
    private String meetExceptTimes;

    public List<String> getMeetExpectTimesList() {
        return Lists.newArrayList(meetExceptTimes.split(","));
    }

}
