package com.bxm.lovelink.common.dal.entity.dto.meet;

import com.bxm.lovelink.common.validator.AllowedIntValues;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author Allen Hu
 * @date 2025/6/18
 */
@Data
public class MeetGroupConfirmMeetResultDto {

    /**
     * 见面群ID
     */
    @NotNull(message = "见面群ID不能为空")
    private Long meetGroupId;

    /**
     * 确认结果。-1 未见面、1 已见面
     */
    @NotNull(message = "确认结果不能为空")
    @AllowedIntValues(value = {0, 1}, message = "确认结果只能为 0 或 1")
    private Integer meetResult;

    /**
     * 见面或未见面说明，是一个json字符串。
     */
    private String description;
}
