package com.bxm.lovelink.common.dal.entity.dto.meet;

import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 发送消息
 *
 * @author Allen Hu
 * @date 2025/5/13
 */
@Data
@Accessors(chain = true)
public class MeetGroupMessageSendDto {

    /**
     * 见面群ID
     */
    @NotNull(message = "请选择发送消息的见面群")
    private Long meetGroupId;
    /**
     * 消息类型。1：普通文本
     */
    @NotNull(message = "请选择消息类型")
    private Integer contentType = Constants.MeetGroupMessageConst.CONTENT_TYPE_TEXT;
    /**
     * 消息内容
     */
    @NotBlank(message = "请填写消息内容")
    private String content;
}
