package com.bxm.lovelink.common.dal.entity.dto.meet;

import lombok.Data;

/**
 * 见面群列表
 *
 * @author Allen Hu
 * @date 2025/5/13
 */
@Data
public class MeetGroupQueryDto {

    /**
     * 见面群类型：NOT_MEETING、MEETING，如果为空则不过滤群状态
     */
    private GroupQueryType groupQueryType;

    public enum GroupQueryType {
        /**
         * 未进入见面状态
         */
        NOT_MEETING,
        /**
         * 已进入见面状态
         */
        MEETING
    }
}
