package com.bxm.lovelink.common.dal.entity.dto.meet;

import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 邀约见面
 *
 * @author Allen Hu
 * @date 2025/5/13
 */
@Data
public class RequestMeetInviteDto {

    /**
     * 被邀请的用户ID
     */
    @NotNull(message = "请选择被邀请的用户")
    private Long userId;

    /**
     * 邀请函内容
     */
    @Deprecated
    private String inviteMessage;

    /**
     * 邀请方需要的红豆数量
     */
    private int meetInviteNeedTicketCount = Constants.MeetGroupConst.MEET_NEED_TICKET_COUNT;

    /**
     * 接受方需要的红豆数量
     */
    private int meetAcceptNeedTicketCount = 0;

    public boolean isFreeRequest() {
        return 0 == meetInviteNeedTicketCount && 0 == meetAcceptNeedTicketCount;
    }
}
