package com.bxm.lovelink.common.dal.entity.dto.meetticket;

import com.bxm.lovelink.common.enums.TicketReturnTypeEnum;
import com.bxm.lovelink.common.enums.TicketRecordTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author tangxiao
 * @date 2025/5/15
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class TicketOperateDto {
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 关联外部id，比如useTicket时为见面群id
     */
    private Long connectId;

    /**
     * 操作类型枚举
     */
    private TicketRecordTypeEnum type;

    /**
     * 操作的备注
     */
    private String remark;

}
