package com.bxm.lovelink.common.dal.entity.dto.order;

import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Objects;

/**
 * @author tangxiao
 * @date 2025/5/16
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class PrepayDto {
    /**
     * 支付渠道，1支付宝支付，2微信支付 3苹果支付
     */
    private int payType;
    /**
     * 客户端类型，0：h5，1：app，2：微信，3：QQ，4：其他
     */
    private int clientType;
    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 微信openid
     */
    private String openId;
    private String clientIp;
    private String reboundUrl;

    public boolean isApplePay() {
        return Objects.equals(payType, Constants.UserOrder.PayType.APPLE_PAY);
    }
}