package com.bxm.lovelink.common.dal.entity.dto.pushtask;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 推送任务
 * @author dll
 * @since 2025-06-13
 */
@Data
public class PushTaskDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 1 即时任务  2定时任务
     */
    @NotNull(message = "任务类型不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Integer taskType;

    /**
     * 任务名称
     */
    @NotBlank(message = "任务名称不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String taskName;

    /**
     * 任务场景
     */
    @NotBlank(message = "任务场景不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String taskScene;

    /**
     * 任务逻辑描述，相同场景的逻辑相同，新增场景需要提前开发好后才能用。比如：在用户注册后3小时<100%完成资料填写则触发推送
     */
    @NotNull(message = "任务类型不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String taskLogicDesc;

    /**
     * 1、ID，2、场景。表示同一ID下计算推送次数或同一场景下计算推送次数。
     * 暂时都是 1 ID
     */
    @NotNull(message = "维度推送次数计数范围不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private Integer taskCountRange;

    /**
     * 生命结束期 以天为单位（就是超过这么多天的数据放弃）
     */
    private Long taskEndOfLife;

    /**
     *  //如果是约见邀请即将过期 与 用户流失召回 这个字段必填
     * 任务场景的特定配置  比如：超时1、3、6小时；留存的n天。
     */
    private String taskSceneCustomConfig;

    /**
     * 推送标题等
     */
    @NotNull(message = "推送标题不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String pushTitle;

    /**
     * 用户收到的消息内容
     */
    @NotNull(message = "推送内容不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String pushMessage;

    /**
     * 推送业务内容，比如跳转的路径等
     */
    private String pushPayload;

    /**
     * 推送最大次数，一般指同一个周期内
     */
    private Integer pushMaximumCount;

    /**
     * 沉默时间（就是任务周期），单位：小时
     */
    private Integer pushCycleHours;

}
