package com.bxm.lovelink.common.dal.entity.dto.question;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 用户问题
 * @author dll
 * @since 2025-05-15
 */
@Data
public class UserQuestionDto implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 问题
     */
    @NotBlank(message = "反馈建议不能为空", groups = {InsertGroup.class})
    @Length(max = 500, message = "反馈建议长度不能超过500", groups = {InsertGroup.class, UpdateGroup.class})
    private String question;


}
