package com.bxm.lovelink.common.dal.entity.dto.user;

import com.bxm.lovelink.common.dal.entity.UserAboutMe;
import com.bxm.lovelink.common.dal.entity.UserAlbum;
import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 用户的基本信息
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
public class UserBasicInfoDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 1 男 0 女
     */
    private Integer gender;
    /**
     * 生日
     */
    private LocalDate birthday;
    /**
     * 身高 cm
     */
    @Range(min = 140, max = 220, message = "身高范围为140-220cm")
    private Integer height;
    /**
     * 现居地 区code
     */
    private Integer currentPlaceDistrict;
    /**
     * 籍贯 区code
     */
    private Integer nativePlaceDistrict;
    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;
    /**
     * 学校名称
     */
    @Length(max = 50, message = "学校名称长度不能超过50")
    private String schoolName;
    /**
     * 学校是否隐藏 1隐藏、0显示
     */
    private Integer schoolHide;
    /**
     * 行业
     */
    private String industry;
    /**
     * 工作
     */
    private String job;
    /**
     * 年收入 2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private Integer yearRevenue;
    /**
     * 婚姻 2未婚、4离异、8丧偶
     */
    private Integer marriage;
    /**
     * 子女 2无子女、4一个儿子、8一个女儿、16一儿一女、32 两个儿子 64 两个女儿、128 两个以上子女
     */
    private Integer children;
    /**
     * 昵称
     */
    @Length(max = 8, message = "昵称超过8个字，请重新输入")
    private String nickname;
    /**
     * 原始图片
     */
    private String originalImage;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 头像压缩
     */
    private String avatarCompress;
    /**
     * 卡片图
     */
    private String cardImage;
    /**
     * 恋爱目标 1没考虑清楚、2短期内想结婚、4先认真谈场恋爱、8先认真谈场恋爱，合适可以结婚
     */
    private Integer loveGoal;
    /**
     * 纹身状态 2小面积或者隐私部位、4大面积明显部位、8没纹身
     */
    private Integer tattooStatus;
    /**
     * 吸烟情况 2偶尔抽烟、4抽烟、8不抽烟
     */
    private Integer smokeStatus;
    /**
     * 房子情况 2、有房，4、无房
     */
    private Integer house;
    /**
     * 房子情况 所在市
     */
    private Integer houseCity;
    /**
     * 车情况 2、有车，4、无车
     */
    private Integer car;
    /**
     * 关于我 列表["介绍1","介绍2","介绍3"]
     */
    private List<UserAboutMe> aboutMe;

    /**
     * 相册 列表["img1url","img2url"]
     */
    @Valid
    @Size(max = 10, message = "最多只能包含10张图片")
    private List<UserAlbum> album;
    /**
     * 声音
     */
    private String voice;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 纬度
     */
    private Double latitude;
    /**
     * 隐藏标签 列表
     */
    private List<UserRuleTag> hideTag;
    /**
     * 兴趣标签 列表 [1,2,3]
     */
    private List<Long> interestTag;
    /**
     * 是否注册完成 1是 0 否
     */
    private Integer registerFinished;
    /**
     * 微信号
     */
    private String wechatNumber;
    /**
     * 体型
     */
    private Integer bodyShape;
    /**
     * ip地址
     */
    private String ip;
}
