package com.bxm.lovelink.common.dal.entity.dto.user;

import com.bxm.lovelink.common.dal.entity.UserCertPeople;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 用户资料认证
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@Accessors(chain = true)
public class UserCertRealPeopleDto implements Serializable {
    /**
     * 认证类别：1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    @NotNull(message = "认证类别不能为空")
    private Integer certType;
    /**
     * 认证状态：0 待审核、1 审核中、2 认证通过、-1 认证失败
     */
    @NotNull(message = "认证状态不能为空")
    private Integer certStatus;
    /**
     * 真人认证信息
     */
    @NotNull(message = "真人认证信息不能为空")
    @Valid
    private UserCertPeople certPeople;

    /**
     * 婚姻认证 默认是false
     */
    private Boolean marryCert = false;

}
