package com.bxm.lovelink.common.dal.entity.dto.user;

import com.bxm.lovelink.common.dal.entity.DecorationScoreDetail;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 用户cms信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-29
 */
@Data
public class UserCmsDto implements Serializable {

    @NotNull(message = "用户cmsId不能为空")
    private Long userCmsId;
    /**
     * 合规 0不合规 1合规
     */
    @NotNull(message = "合规状态不能为空")
    private Integer complianceStatus;
    /**
     * 不合规原因
     */
    private List<Integer> complianceNoReason;
    /**
     * 颜值等级  1一般 2普通 3优质
     */
    @NotNull(message = "颜值等级不能为空")
    private Integer appearanceLevel;
    /**
     * 装修得分明细 json格式
     */
    @NotEmpty(message = "装修得分明细不能为空")
    @Valid
    @Size(min = 7,max=7,message = "每个装修分类都得设置")
    private List<DecorationScoreDetail> decorationScoreDetail;
}
