package com.bxm.lovelink.common.dal.entity.dto.user;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.List;

/**
 * <p>
 * 用户理想伴侣信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
public class UserLoveConditionDto {
    private static final long serialVersionUID = 1L;
    /**
     * 年龄范围 最小值
     */
    @Min(value = 18, message = "年龄最小值不能小于18")
    private Integer ageRangeMin;

    /**
     * 年龄范围 最大值
     */
    @Max(value = 120, message = "年龄最大值不能大于120")
    private Integer ageRangeMax;
    /**
     * 身高范围 最小值
     */
    private Integer heightRangeMin;
    /**
     * 身高范围 最大值
     */
    private Integer heightRangeMax;
    /**
     * 学历 列表  1不限、2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private List<Integer> eduRange;

    /**
     * 学校范围 列表 [1,2,3]  1不限、2 985 211院校
     */
    private List<Integer> schoolRange;

    /**
     * 婚姻孩子范围 按位或运算 1不限、2未婚、4离异 无子女、8离异 一个女儿、16离异 一个儿子、32离异 多个子女、64丧偶 无子女、128丧偶有子女
     */
    private List<Integer> marriageChildrenRange;

    /**
     * 婚姻孩子范围 按位或运算 1不限、2未婚、4离异 无子女、8离异 一个女儿、16离异 一个儿子、32离异 多个子女、64丧偶 无子女、128丧偶有子女
     */
    private List<Integer> marriageChildrenRelaxRange;

    /**
     * 籍贯范围  列表 [1,2,3]
     */
    private List<Integer>  nativePlaceRange;

    /**
     * 恋爱目标范围  列表 [1,2,3] 1没考虑清楚、2短期内想结婚、4先认真谈场恋爱、8先认真谈场恋爱，合适可以结婚
     */
    private List<Integer> loveGoalRange;

    /**
     * 纹身情况范围 列表 [1,2,3]  1不介意、2小面积或者隐私部位、4大面积明显部位、8不接受任何纹身
     */
    private List<Integer> tattooStatusRange;

    /**
     * 吸烟情况范围 列表 [1,2,3] 1不介意、2偶尔抽烟、4抽烟、8不接受抽烟
     */
    private List<Integer> smokeStatusRange;

    /**
     * 行业情况  列表 [1,2,3] 1无所谓、2同行、4非同行
     */
    private List<Integer>  industryRange;

    /**
     * 工作情况   列表 [1,2,3] 1无所谓、2稳定工作、4创业经商
     */
    private List<Integer> jobRange;

    /**
     * 生活情况  列表 [1,2,3]  1无所谓、2顾家、4事业
     */
    private List<Integer> lifeRange;

    /**
     * 年收入情况  列表 [1,2,3]  1无所谓、2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private List<Integer> yearRevenueRange;
    /**
     * 车情况  列表 [1,2,3] 1无所谓、2、有车，4、无车
     */
    private List<Integer> carRange;
    /**
     * 房子情况  列表 [1,2,3] 1无所谓、2、有房，4、无房
     */
    private List<Integer> houseRange;
    /**
     * 体型
     */
    private List<Integer> bodyShapeRange;
    /**
     * 其他需求 json格式
     */
    private String otherRange;

}
