package com.bxm.lovelink.common.dal.entity.dto.user;

import com.bxm.lovelink.common.dal.entity.base.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/29
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UserQueryDto  extends PageRequest {
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 1 男 0 女
     */
    private Integer gender;
    /**
     * 年龄最小值
     */
    private Integer ageMin;
    /**
     * 年龄最大值
     */
    private Integer ageMax;
    /**
     * 生日开始日期
     */
    private LocalDate birthdayStart;
    /**
     * 生日结束日期
     */
    private LocalDate birthdayEnd;
    /**
     * 用户资料完成进度
     * 1 0<完成度<30%、 2 30%<=完成度<60%、 3完成度>=60%
     */
    private List<Integer> infoCompleteProgressLevel;
    /**
     * 0待审核 1审核
     */
    private Integer auditStatus;
    /**
     * 合规 0不合规 1合规
     */
    private Integer complianceStatus;
    /**
     * 颜值等级  1一般 2普通 3优质
     */
    private List<Integer> appearanceLevel;
    /**
     * 装修得分等级
     *  1 0<=完成度<=59、 2 60%<=完成度<79%、 3完成度>=80
     */
    private List<Integer> decorationScoreLevel;

}
