package com.bxm.lovelink.common.dal.entity.dto.version;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author daill
 * @date 2025/5/14
 */
@Data
public class LovelinkAppVersionDto {

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;
    /**
     * 渠道类型
     */
    private String channel;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 版本
     */
    @NotBlank(message = "版本不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String version;


    /**
     * 是否强制更新  0 不强制  1强制
     */
    private Integer isUpdate;
}
