package com.bxm.lovelink.common.dal.entity.vo.activity;


import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.dal.entity.GuestRecommend;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityGuestRecommendDto;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 活动中心数据
 *
 * @author: weixing
 */
@Data
public class ActivityCenterVo {
    /**
     * 活动ID
     */
    private Long activityId;


    /**
     * 活动可见范围： 0 私有 1公开
     */
    private Integer overtStatus;
    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 城市code
     */
    private String cityCode;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 活动类型ID
     */
    private Long activityTypeId;

    /**
     * 活动类型ID
     */
    private String activityTypeName;

    /**
     * 活动负责人名称
     */
    private String organizerName;


    /**
     * 报名费用
     */
    private BigDecimal registerPrice;


    /**
     * 活动报名人数
     */
    private Integer registrationCount;

    /**
     * 活动签到人数
     */
    private Integer signInCount;

    /**
     * 活动评价人数
     */
    private Integer evaluationCount;

    /**
     * 平均得分
     */
    private Double avgScore;

    /**
     * 活动结束时间
     */
    private LocalDateTime activityEndTime;


    /**
     * 复参意愿（=该活动评论下，愿意复参的用户/ 该活动的评论总数）
     */
    private Double repeatIndex;
}
