package com.bxm.lovelink.common.dal.entity.vo.activity;


import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserVo;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 活动详情VO
 * @author: weixing
 */
@Data
public class ActivityDetailVo {
    /**
     * 活动ID
     */
    private Long id;

    /**
     * 头图
     */
    private String headImage;
    /**
     * 封面图片
     */
    private String coverImage;
    /**
     * 列表封面图
     */
    private String listCoverImage;

    /**
     * 城市code
     */
    private String cityCode;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 活动类型ID
     */
    private Long activityTypeId;

    /**
     * 活动负责人ID
     */
    private Long organizerId;

    /**
     * 活动负责人名称
     */
    private String organizerName;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动简介
     */
    private String intro;

    /**
     * 新用户免费 0-否 1-是
     */
    private Integer newUserFree;

    /**
     * 报名费用
     */
    private BigDecimal registerPrice;

    /**
     * 早鸟票价
     */
    private BigDecimal discountPrice;

    /**
     * 早鸟票方式：1-日期 2-名额
     */
    private Integer discountLimitType;

    /**
     * 早鸟票开始时间
     */
    private LocalDateTime discountStartTime;

    /**
     * 早鸟票结束时间
     */
    private LocalDateTime discountEndTime;

    /**
     * 早鸟票限制名额
     */
    private Integer discountLimitCount;

    /**
     * 早鸟票已报名人数
     */
    private Integer discountRegisterCount;

    /**
     * 活动开始时间
     */
    private LocalDateTime activityStartTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime activityEndTime;

    /**
     * 活动报名开始时间
     */
    private LocalDateTime registerStartTime;

    /**
     * 活动报名结束时间
     */
    private LocalDateTime registerEndTime;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 详细活动地址
     */
    private String addressDetail;

    /**
     * 活动上限人数
     */
    private Integer participantsLimit;

    /**
     * 男生上限人数
     */
    private Integer maleParticipantsLimit;

    /**
     * 女生上限人数
     */
    private Integer femaleParticipantsLimit;

    /**
     * 男生报名人数
     */
    private Integer maleRegisteredCount = 0;

    /**
     * 女生报名人数
     */
    private Integer femaleRegisteredCount = 0;

    /**
     * 活动介绍图片 list类型的json字符串
     */
    private String introImages;

    /**
     * 封面图片 list类型的json字符串
     */
    private String coverImages;

    /**
     * 活动流程图片 list类型的json字符串
     */
    private String flowImages;

    /**
     * 退款规则图片 list类型的json字符串
     */
    private String refundPolicyImages;

    /**
     * 注意事项图片 list类型的json字符串
     */
    private String noticeImages;

    /**
     * 企微二维码 list类型的json字符串
     */
    private String wecomQrCode;

    /**
     * 嘉宾推荐
     */
    private GuestRecommendVo guestRecommend;

    /**
     * 活动报名价格
     */
     private BigDecimal activityPrice;

    /**
     * 活动展示价格
     */
    private BigDecimal activityShowPrice;

    /**
     * 活动业务类型 0-其他 1-互选
     */
    private Integer activityBizType;

    /**
     * 活动报名用户
     */
    private List<ActivityUserVo> activityUserList;

    /**
     * 活动状态 0-未开始 1-进行中 2-已结束 3-名额已满 4-报名已结束 5-报名中
     */
    private Integer status;

    /**
     * 活动报名状态 1-未报名 2-已报名 3-已退款
     */
    private Integer registerStatus = 1;

    /**
     * 活动可见范围： 0 私有 1公开
     */
    private Integer overtStatus;

    public String getCoverImage(){
        if (StringUtils.isNotBlank(coverImages)){
            List<String> coverImageList = JSONObject.parseArray(coverImages, String.class);
            return CollUtil.getFirst(coverImageList);
        }
        return coverImage;
    }
    public String getListCoverImage(){
        if (StringUtils.isNotBlank(coverImages)){
            List<String> coverImageList = JSONObject.parseArray(coverImages, String.class);
            return CollUtil.getLast(coverImageList);
        }
        return listCoverImage;
    }
}
