package com.bxm.lovelink.common.dal.entity.vo.activity;


import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.Getter;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 活动支付配置
 * @author: weixing
 */
@Data
public class ActivityPayConfigVo {
    /**
     * ios 支付方式 1-支付宝 2-微信 3-苹果
     */
    private List<Integer> iosPayTypes;
    /**
     * android支付方式 1-支付宝 2-微信 3-苹果
     */
    private List<Integer> androidPayTypes;

    /**
     * 是否启用苹果h5支付
     */
    private Boolean enableIosH5Pay;
    /**
     * 活动价格与苹果产品id映射
     */
    private Map<BigDecimal, String> appleProductIdMap = new HashMap<>();

    /**
     * 支付方式枚举
     */
    @Getter
    public enum PayType {
        ALI_PAY(1, "支付宝"),
        WECHAT_PAY(2, "微信"),
        APPLE(3, "苹果");
        private final Integer code;
        private final String name;
        PayType(Integer code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    public static void main(String[] args) {
        ActivityPayConfigVo activityPayConfigVo = new ActivityPayConfigVo();
        activityPayConfigVo.setIosPayTypes(Lists.newArrayList(3));
        activityPayConfigVo.setAndroidPayTypes(Lists.newArrayList(1, 2));
        activityPayConfigVo.setEnableIosH5Pay(false);
        System.out.println(JsonHelper.convert(activityPayConfigVo));
    }
}
