package com.bxm.lovelink.common.dal.entity.vo.activity;


import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 嘉宾推荐
 * @author: weixing
 */
@Data
@Accessors(chain = true)
public class GuestRecommendVo {
    /**
     * 男嘉宾列表
     */
    private List<GuestUser> maleGuestList;
    /**
     * 女嘉宾列表
     */
    private List<GuestUser> femaleGuestList;

    @Data
    @Accessors(chain = true)
    public static class GuestUser {
        /**
         * 用户id
         */
        private Long userId;
        /**
         * 嘉宾描述
         */
        private String desc;

        /**
         * 用户头像
         */
        private String avatar;
        /**
         * 用户编号
         */
        private String userNumber;

        /**
         * 昵称
         */
        private String nickname;

        /**
         * 年龄
         */
        private Integer age;

        /**
         * 工作
         */
        private String job;

        /**
         * 规则标签
         */
        private List<UserRuleTag> ruleTag;

        /**
         * 身高 cm
         */
        private Integer height;


    }
}
