package com.bxm.lovelink.common.dal.entity.vo.activity.registration;


import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author: weixing
 */
@Data
@Accessors(chain = true)
public class ActivityRegistrationResultVo {
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 待支付报名费用
     */
    private BigDecimal activityPrice;
    /**
     * 报名结果 0-成功-待支付 1-名额已满 2-早鸟票售罄 3-存在待支付订单
     */
    private Integer result = 0;

    /**
     * 苹果产品 Id
     */
    private String appleProductId;


    public static ActivityRegistrationResultVo buildFailResult(Long activityId, Integer resultCode) {
        return new ActivityRegistrationResultVo()
                .setActivityId(activityId)
                .setResult(resultCode);
    }

    public static ActivityRegistrationResultVo buildPayResult(Long activityId, String orderNo, BigDecimal price, String appleProductId) {
        return new ActivityRegistrationResultVo()
                .setActivityId(activityId)
                .setOrderNo(orderNo)
                .setActivityPrice(price)
                .setAppleProductId(appleProductId);
    }

    public static ActivityRegistrationResultVo buildFreeResult(Long activityId, BigDecimal price) {
        return new ActivityRegistrationResultVo()
                .setActivityId(activityId)
                .setActivityPrice(price);
    }

    public static ActivityRegistrationResultVo buildWaitPayResult(Long activityId, String orderNo, BigDecimal price, String appleProductId) {
        return new ActivityRegistrationResultVo()
                .setActivityId(activityId)
                .setOrderNo(orderNo)
                .setActivityPrice(price)
                .setAppleProductId(appleProductId)
                .setResult(Constants.RegistrationResult.EXIST_UNPAID_ORDER);
    }

    public static ActivityRegistrationResultVo buildFailResult(Long activityId, int resultCode, BigDecimal registerPrice) {
        return new ActivityRegistrationResultVo()
                .setActivityId(activityId)
                .setResult(resultCode)
                .setActivityPrice(registerPrice);
    }
}
