package com.bxm.lovelink.common.dal.entity.vo.activity.registration;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author dll
 * @date 2025/6/24
 */
@Data
public class ActivityRegistrationVo {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 昵称
     */
    private String nickname;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 报名时间
     */
    private LocalDateTime registrationTime;


    /**
     * 支付类型 1 支付宝 2 微信  3 原生
     */
    private Integer payType;
    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 支付金额
     */
    private String paymentAmount;

    /**
     * 活动报名状态 0-待支付 1- 超时未支付 2-已支付 3-已退款
     */
    private Integer status;
    /**
     * 签到状态  0未签到 1 已签到
     */
    private String signInStatus;

    /**
     * 签到时间
     */
    private String signInTime;
}
