package com.bxm.lovelink.common.dal.entity.vo.application;

import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author daill
 * @date 2024/4/28
 */
@Data
public class AiApplacationVo {

    private Long id;

    private String applicationName;


    /**
     * 应用介绍
     */
    private String applicationDescription;


    /**
     * 对应百炼应用ID
     */
    @NotBlank(message = "appId不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String appId;

    /**
     * 业务空间ID
     */
    @NotBlank(message = "workspaceId不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String workspaceId;
}
