package com.bxm.lovelink.common.dal.entity.vo.chat;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 用户的聊天消息
 */
@Data
public class ChatSessionMessageVo {

    private Long id;

    /**
     * 会话ID
     */
    private Long sessionId;

    /**
     * 说话人角色：
     * user : app用户
     * assistant : AI回复
     * staff : 人工回复
     * ui :
     */
    private String role;

    /**
     * 消息类型。0 截断符号、1 文本消息、2 图文、3 用户卡片
     */
    private Integer contentType;

    /**
     * 推理内容
     */
    private String reasoningContent;

    /**
     * 正文内容
     */
    private String content;

    /**
     * 附件内容，JSON数据，一般根据消息类型来定义自己的数据模型
     */
    private String attachments;

    /**
     * 消息发送时间
     */
    private LocalDateTime createTime;
}
