package com.bxm.lovelink.common.dal.entity.vo.heartbeat;

import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 *  心动列表
 *
 * @author weixing
 */
@Data
public class HeartBeatListVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    private Long id;

    /**
     * 用户 ID
     */
    private Long userId;

    /**
     * 用户编号
     */
    private String userNumber;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 卡片图
     */
    private String cardImage;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 性别 1-男 0-女
     */
    private Integer gender;

    /**
     * 现居地 市
     */
    private Integer currentPlaceCity;

    /**
     * 现居地城市名称
     */
    private String currentPlaceCityName;

    /**
     * 星座
     */
    private Integer constellation;

    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;

    /**
     * 工作
     */
    private String job;

    /**
     * 规则标签
     */
    private List<UserRuleTag> ruleTag;

    /**
     * 身高 cm
     */
    private Integer height;
    /**
     * 距离，单位：m
     */
    private Integer distance;

    /**
     * 关系来源 0-用户行为 1-红娘推荐
     */
    private Integer relationSource;

    /**
     * 是否已读 0-未读 1-已读
     */
    private Integer readStatus;

    /**
     * 匹配度
     */
    private BigDecimal matchScore;

    /**
     * 删除标识 1-删除 0-正常
     */
    private Integer deleted;

    /**
     * 是否匹配 0 - 未匹配 1 - 已匹配
     */
    private Integer matched;

    /**
     * 在线状态
     */
    private String onlineStatus = "2天前在线";

    public List<UserRuleTag> getRuleTag() {
        if (CollectionUtils.isEmpty(ruleTag)) {
            return ruleTag;
        }
        if (ruleTag.size() > 5) {
            return ruleTag.subList(0, 5);
        }
        return ruleTag;
    }

}
