package com.bxm.lovelink.common.dal.entity.vo.meet;

import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询见面状态结果
 *
 * @author Allen Hu
 * @date 2025/5/13
 */
@Data
@Accessors(chain = true)
public class MeetGroupQueryStatusVo {

    /**
     * 见面群信息，如果没有邀约则为空
     */
    private MeetGroupQueryVo meetGroupQuery;

    /**
     * 约见对方一共需要几颗红豆
     */
    private int meetNeedTicketCount = Constants.MeetGroupConst.MEET_NEED_TICKET_COUNT;

    /**
     * VIP用户发起见面允许减少的相亲券数量
     */
    private int vipReductionTicketCount = Constants.MeetGroupConst.VIP_REDUCTION_TICKET_COUNT;
}
