package com.bxm.lovelink.common.dal.entity.vo.meet;

import com.google.common.collect.Lists;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * 见面群详情
 *
 * @author Allen Hu
 * @date 2025/5/13
 */
@Data
public class MeetGroupQueryVo {

    private Long id;

    /**
     * 邀请人
     */
    private Long inviteUserId;

    /**
     * 接受人
     */
    private Long acceptUserId;

    /**
     * 邀请函内容
     */
    private String inviteMessage;

    /**
     * 邀请人已读状态。0 未读、1 已读
     */
    private Integer inviteUserReadMark;

    /**
     * 接收人已读状态。0 未读、1 已读
     */
    private Integer acceptUserReadMark;

    /**
     * 群状态。-1 拒绝、-2 举报、0 发出了邀请、1 同意沟通中、2 沟通结束不见面、3 见面成功、4 见面失败、-3 邀请超时
     */
    private Integer groupStatus;

    /**
     * 举报或拒绝原因
     */
    private String rejectMeetReason;

    /**
     * 见面需要多少颗红豆
     */
    private Integer meetNeedTicketCount;

    /**
     * 邀请方需要的红豆数量
     */
    private Integer meetInviteNeedTicketCount;

    /**
     * 接受方需要的红豆数量
     */
    private Integer meetAcceptNeedTicketCount;

    /**
     * 邀请方使用的红豆数量
     */
    private Integer meetInviteUseTicketCount;

    /**
     * 接受方使用的红豆数量
     */
    private Integer meetAcceptUseTicketCount;

    /**
     * 选择约会时间地点的用户ID
     */
    private Long meetSelectAddressUserId;

    /**
     * 见面状态：0 等待选择约会时间和地点、1 等待确认、2 已确认
     */
    private Integer meetStatus;

    /**
     * 见面地址
     */
    private String meetAddress;

    /**
     * 期望的见面时间段，多个用英文逗号隔开。如：2025-11-12 09:00-10:00,2025-11-13 09:00-10:00
     */
    private String meetExceptTimes;

    /**
     * 确定见面时间
     */
    private String meetTime;

    /**
     * 见面开始时间
     */
    private LocalDateTime meetTimeStart;

    /**
     * 见面结束时间
     */
    private LocalDateTime meetTimeEnd;

    /**
     * 邀请人是否确认见面，0 未见面、1 已见面
     */
    private Integer meetInviteUserResult;

    private String meetInviteUserResultDesc;

    /**
     * 接收人是否确认见面，0 未见面、1 已见面
     */
    private Integer meetAcceptUserResult;

    private String meetAcceptUserResultDesc;

    /**
     * 邀请超时时间
     */
    private LocalDateTime inviteExpireTime;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 邀请人
     */
    private MeetUserVo inviteUserVo;

    /**
     * 受邀人
     */
    private MeetUserVo acceptUserVo;

    /**
     * 见面群最后一条消息
     */
    private String lastMessageContent;

    /**
     * 见面群最后消息时间
     */
    private LocalDateTime lastMessageTime;

    public List<String> splitMeetExceptTimes() {
        if (meetExceptTimes == null) {
            return null;
        }
        return Lists.newArrayList(meetExceptTimes.split(","));
    }

    /**
     * 返回对方的信息
     * @param myUserId 我的用户ID
     * @return 对方
     */
    public MeetUserVo getTA(Long myUserId) {
        if (Objects.equals(inviteUserId, myUserId)) {
            return acceptUserVo;
        } else {
            return inviteUserVo;
        }
    }

    /**
     * 返回我的见面结果
     * @param myUserId 我的用户ID
     * @return 线下见面结果
     */
    public Integer getMeetResult(Long myUserId) {
        if (Objects.equals(inviteUserId, myUserId)) {
            return getMeetInviteUserResult();
        } else {
            return getMeetAcceptUserResult();
        }
    }
}
