package com.bxm.lovelink.common.dal.entity.vo.meet;

import com.bxm.lovelink.common.utils.UserUtils;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author Allen Hu
 * @date 2025/5/16
 */
@Data
public class MeetUserVo {

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户编号
     */
    private String userNumber;

    /**
     * 性别：1 男 0 女
     */
    private Integer gender;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * VIP 过期时间
     */
    private LocalDateTime vipExpireTime;

    /**
     * 用户状态
     */
    private Integer status;

    public boolean isVip() {
        return UserUtils.isVip(vipExpireTime);
    }
}
