package com.bxm.lovelink.common.dal.entity.vo.meetticket;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author tangxiao
 * @date 2025/5/16
 * @since 1.0
 */
@Data
public class TicketProductVo {

    private Long id;

    /**
     * 红豆商品名称
     */
    private String name;

    /**
     * 类型。1 普通次卡、2 vip卡
     */
    private Integer productType;

    /**
     * 原价
     */
    private BigDecimal marketPrice;

    /**
     * 优惠价
     */
    private BigDecimal discountPrice;

    /**
     * 折扣率 0.8=8折
     */
    private BigDecimal discountRate;

    /**
     * 红豆数量
     */
    private Integer amount;

    /**
     * 描述
     */
    private String description;

    /**
     * 标签：如 推荐 json格式
     */
    private String commentTags;

    /**
     * 苹果产品id
     */
    private String appleProductId;

    /**
     * vip是否自动续费，1 是，0 否
     */
    private Integer isAutoRenew;
}
