package com.bxm.lovelink.common.dal.entity.vo.order;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订单vo
 */
@Data
public class UserOrderVo {

    /**
     * 订单 id
     */
    private String orderNum;

    /**
     * 红豆商品id
     */
    private Long meetTicketProductId;

    /**
     * 商品类型：1 普通次卡、2 vip卡、 3 付费认证
     */
    private Integer productType;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 商品描述，比如购买周期
     */
    private String productDesc;

    /**
     * 红豆数量
     */
    private Integer productAmount;

    /**
     * 商品扩展信息，json格式
     */
    private String productExtJson;

    /**
     * 订单金额
     */
    private BigDecimal totalPrice;

    /**
     * 实付金额
     */
    private BigDecimal paymentAmount;

    /**
     * 0- 待支付、1- 支付中、2- 支付成功、3- 已关闭、4- 已取消
     */
    private Integer status;

    /**
     * 支付方式：1.支付宝 2.微信 3.Apple
     */
    private Integer payType;

    /**
     * 支付平台订单号
     */
    private String paymentId;

    /**
     * 扩展类型
     */
    private Integer extType;

    /**
     * 扩展信息，json格式
     */
    private String extJson;

    private LocalDateTime createTime;

    /**
     * 订单支付时间
     */
    private LocalDateTime paymentTime;

    /**
     * 红豆开始日期
     */
    private String ticketCreateDate;

    /**
     * 红豆过期日期
     */
    private String ticketExpireDate;
}
