package com.bxm.lovelink.common.dal.entity.vo.user;

import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserAboutMe;
import com.bxm.lovelink.common.dal.entity.UserAlbum;
import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import com.bxm.lovelink.common.utils.UserUtils;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户的基本信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
public class UserBasicInfoVo {
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 1 男 0 女
     */
    private Integer gender;
    /**
     * 生日
     */
    private LocalDate birthday;
    /**
     * 年龄
     */
    private Integer age;
    /**
     * 生肖
     */
    private Integer zodiac;
    /**
     * 生肖名
     */
    private String zodiacName;
    /**
     * 星座
     */
    private Integer constellation;
    /**
     * 星座名
     */
    private String constellationName;
    /**
     * 身高 cm
     */
    private Integer height;
    /**
     * 现居地 省code
     */
    private Integer currentPlaceProvince;
    /**
     * 现居地 省名称
     */
    private String currentPlaceProvinceName;
    /**
     * 现居地 市code
     */
    private Integer currentPlaceCity;
    /**
     * 现居地 市名称
     */
    private String currentPlaceCityName;
    /**
     * 现居地 区code
     */
    private Integer currentPlaceDistrict;
    /**
     * 现居地 区名称
     */
    private String currentPlaceDistrictName;
    /**
     * 籍贯 省code
     */
    private Integer nativePlaceProvince;
    /**
     * 籍贯 省名称
     */
    private String nativePlaceProvinceName;
    /**
     * 籍贯 市code
     */
    private Integer nativePlaceCity;
    /**
     * 籍贯 市名称
     */
    private String nativePlaceCityName;
    /**
     * 籍贯 区code
     */
    private Integer nativePlaceDistrict;
    /**
     * 籍贯 区名称
     */
    private String nativePlaceDistrictName;
    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;
    /**
     * 学历名
     */
    private String eduHighestName;
    /**
     * 学校名称
     */
    private String schoolName;
    /**
     * 学校是否隐藏 1隐藏、0显示
     */
    private Integer schoolHide;
    /**
     * 行业
     */
    private String industry;
    /**
     * 工作
     */
    private String job;
    /**
     * 年收入 2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private Integer yearRevenue;
    /**
     * 年收入名
     */
    private String yearRevenueName;
    /**
     * 婚姻 2未婚、4离异、8丧偶
     */
    private Integer marriage;
    /**
     * 婚姻名
     */
    private String marriageName;
    /**
     * 子女 2无子女、4一个儿子、8一个女儿、16一儿一女、32 两个儿子 64 两个女儿、128 两个以上子女
     */
    private Integer children;
    /**
     * 子女名
     */
    private String childrenName;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 头像压缩
     */
    private String avatarCompress;
    /**
     * 卡片图
     */
    private String cardImage;
    /**
     * 恋爱目标 1没考虑清楚、2短期内想结婚、4先认真谈场恋爱、8先认真谈场恋爱，合适可以结婚
     */
    private Integer loveGoal;
    /**
     * 恋爱目标名
     */
    private String loveGoalName;
    /**
     * 纹身状态 2小面积或者隐私部位、4大面积明显部位、8没纹身
     */
    private Integer tattooStatus;
    /**
     * 纹身状态名
     */
    private String tattooStatusName;
    /**
     * 吸烟情况 2偶尔抽烟、4抽烟、8不抽烟
     */
    private Integer smokeStatus;
    /**
     * 吸烟情况名
     */
    private String smokeStatusName;
    /**
     * 房子情况 2、有房，4、无房
     */
    private Integer house;
    /**
     * 购房情况名
     */
    private String houseName;
    /**
     * 房子情况 所在市
     */
    private Integer houseCity;
    /**
     * 房子情况 所在市名称
     */
    private String houseCityName;
    /**
     * 房子情况 所在省
     */
    private Integer houseProvince;
    /**
     * 房子情况 所在省名称
     */
    private String houseProvinceName;
    /**
     * 车情况 2、有车，4、无车
     */
    private Integer car;
    /**
     * 购车情况名
     */
    private String carName;
    /**
     * 关于我 列表["介绍1","介绍2","介绍3"]
     */
    private List<UserAboutMe> aboutMe;

    /**
     * 相册 列表["img1url","img2url"]
     */
    private List<UserAlbum> album;
    /**
     * 声音
     */
    private String voice;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 纬度
     */
    private Double latitude;
    /**
     * 最后登录地区
     */
    private Integer lastLoginDistrict;
    /**
     * 最后登录地区名称
     */
    private String lastLoginDistrictName;
    /**
     * 距离
     */
    private Double distance;
    /**
     * 规则标签 列表
     */
    private List<UserRuleTag> ruleTag;
    /**
     * 隐藏标签 列表
     */
    private List<UserRuleTag> hideTag;
    /**
     * 兴趣标签 列表 [1,2,3]
     */
    private List<Long> interestTag;
    /**
     * 兴趣标签名 列表
     */
    private List<UserTagVo> interestTagVo;
    /**
     * 用户资料认证进度，百分比
     */
    private Integer infoCertProgress;
    /**
     * 用户资料完成进度，百分比
     */
    private Integer infoCompleteProgress;
    /**
     * vip过期时间 不为空且时间>当前时间为vip
     */
    private LocalDateTime vipExpireTime;
    /**
     * 微信号
     */
    private String wechatNumber;
    /**
     * 认证状态 1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    private List<Integer> certStatus;
    /**
     * 体型
     */
    private Integer bodyShape;
    /**
     * 体型名
     */
    private String bodyShapeName;
    /**
     * 信任度
     */
    private Integer trustPercent;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;


    public Integer getAge() {
        if (this.birthday != null) {
            return birthday.until(LocalDate.now()).getYears();
        }
        return null;
    }

    public Integer getCurrentPlaceProvince() {
        if (currentPlaceDistrict == null) {
            return null;
        }
        return currentPlaceDistrict / 10000 * 10000;
    }

    public Integer getCurrentPlaceCity() {
        if (currentPlaceDistrict == null) {
            return null;
        }
        return currentPlaceDistrict / 100 * 100;
    }

    public Integer getNativePlaceProvince() {
        if (nativePlaceDistrict == null) {
            return null;
        }
        return nativePlaceDistrict / 10000 * 10000;
    }

    public Integer getNativePlaceCity() {
        if (nativePlaceDistrict == null) {
            return null;
        }
        return nativePlaceDistrict / 100 * 100;
    }

    public Integer getHouseProvince() {
        if (houseCity == null) {
            return null;
        }
        return houseCity / 10000 * 10000;
    }

    public String getEduHighestName() {
        return UserConstants.getNameByCode(UserConstants.EduHighestEnum.class, eduHighest);
    }

    public String getZodiacName() {
        return UserConstants.getNameByCode(UserConstants.UserZodiacEnum.class, zodiac);
    }

    public String getConstellationName() {
        return UserConstants.getNameByCode(UserConstants.UserConstellationEnum.class, constellation);
    }

    public String getMarriageName() {
        return UserConstants.getNameByCode(UserConstants.MarriageStatusEnum.class, marriage);
    }

    public String getChildrenName() {
        return UserConstants.getNameByCode(UserConstants.ChildrenStatusEnum.class, children);
    }

    public String getHouseName() {
        return UserConstants.getNameByCode(UserConstants.HouseEnum.class, house);
    }

    public String getCarName() {
        return UserConstants.getNameByCode(UserConstants.CarEnum.class, car);
    }

    public String getYearRevenueName() {
        return UserConstants.getNameByCode(UserConstants.YearRevenueEnum.class, yearRevenue);
    }

    public String getLoveGoalName() {
        return UserConstants.getNameByCode(UserConstants.LoveGoalEnum.class, loveGoal);
    }

    public String getTattooStatusName() {
        return UserConstants.getNameByCode(UserConstants.TattooStatusEnum.class, tattooStatus);
    }

    public String getSmokeStatusName() {
        return UserConstants.getNameByCode(UserConstants.SmokeStatusEnum.class, smokeStatus);
    }

    public String getBodyShapeName() {
        return UserConstants.getNameByCode(UserConstants.BodyShapeEnum.class, bodyShape);
    }

    /**
     * 供前端使用
     */
    public boolean isVip() {
        return UserUtils.isVip(vipExpireTime);
    }
}
