package com.bxm.lovelink.common.dal.entity.vo.user;

import com.bxm.lovelink.common.dal.entity.*;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户资料认证
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@Accessors(chain = true)
public class UserCertVo implements Serializable {
    /**
     * 认证类别：1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    private Integer certType;
    /**
     * 认证状态：0 待审核、1 审核中、2 认证通过、-1 认证失败
     */
    private Integer certStatus;
    /**
     * 实人认证信息
     */
    private UserCertPeople certPeople;

    /**
     * 认证结果
     */
    private UserCertResult certResult;

    /**
     * 认证更新时间
     */
    private LocalDateTime modifyTime;
}
