package com.bxm.lovelink.common.dal.entity.vo.user;

import com.bxm.lovelink.common.dal.entity.DecorationScoreDetail;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 用户cms信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-29
 */
@Data
public class UserCmsVo implements Serializable {

    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 审核状态 0待审核 1审核完成
     */
    private Integer auditStatus;

    /**
     * 合规 0不合规 1合规
     */
    private Integer complianceStatus;
    /**
     * 不合规原因
     */
    private List<Integer> complianceNoReason;
    /**
     * 颜值等级  1一般 2普通 3优质
     */
    private Integer appearanceLevel;
    /**
     * 装修得分 满分100
     */
    private Integer decorationScore;
    /**
     * 装修得分明细
     */
    private List<DecorationScoreDetail> decorationScoreDetail;
}
