package com.bxm.lovelink.common.dal.entity.vo.user;

import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.entity.UserCertResult;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author zhangdong
 * @date 2025/5/19
 */
@Data
@Accessors(chain = true)
public class UserCompositeVo {
    private UserVo user;
    private UserBasicInfoVo userBasicInfo;
    private UserLoveConditionVo userLoveCondition;
    private UserOtherInfoVo userOtherInfo;
    private List<UserCertVo> userCerts;
    private UserCmsVo userCms;
    /**
     * 是否活跃 true活跃 false不活跃
     */
    private Boolean active = false;
    /**
     * 头像审核情况 认证状态：0 待审核、1 审核中、2 审核通过、-1 审核失败
     */
    private Integer avatarAuditStatus;
    /**
     * 已婚状态  0处理中 1 已婚 null 其他
     */
    private Integer marriedStatus;

    public Integer getMarriedStatus() {
        if (CollectionUtils.isEmpty(userCerts)) {
            return null;
        }
        UserCertVo userCertVo = userCerts.stream().filter(userCert -> UserConstants.CertTypeEnum.MARRIED.getCode().equals(userCert.getCertType()))
                .findFirst().orElse(null);
        if (userCertVo == null) {
            return null;
        }
        //查询认证结果
        if (Objects.equals(userCertVo.getCertStatus(), UserCert.STATUS_PASS)) {
            UserCertResult certResult = userCertVo.getCertResult();
            if (certResult != null && Objects.equals(certResult.getStatus(), Constants.YES)) {
                return Constants.YES;
            }
            return null;
        }
        return Constants.NO;
    }



}
