package com.bxm.lovelink.common.dal.entity.vo.user;

import com.bxm.lovelink.common.contant.UserConstants;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 用户理想伴侣信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
public class UserLoveConditionSimpleVo {
    /**
     * 年龄范围 最小值
     */
    private Integer ageRangeMin;

    /**
     * 年龄范围 最大值
     */
    private Integer ageRangeMax;
    /**
     * 身高范围 最小值
     */
    private Integer heightRangeMin;
    /**
     * 身高范围 最大值
     */
    private Integer heightRangeMax;
    /**
     * 学历 按位或运算 1不限、2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private List<Integer> eduRange;
    /**
     * 学历名称
     */
    private List<String> eduRangeName;
    /**
     * 学校范围 按位或运算 1不限、2 985 211院校
     */
    private List<Integer> schoolRange;
    /**
     * 学校范围名称
     */
    private List<String> schoolRangeName;
    /**
     * 婚姻孩子范围 按位或运算 1不限、2未婚、4离异 无子女、8离异 一个女儿、16离异 一个儿子、32离异 多个子女、64丧偶 无子女、128丧偶有子女
     */
    private List<Integer> marriageChildrenRange;
    /**
     * 婚姻孩子范围名称
     */
    private List<String> marriageChildrenRangeName;

    /**
     * 婚姻孩子范围 按位或运算 1不限、2未婚、4离异 无子女、8离异 一个女儿、16离异 一个儿子、32离异 多个子女、64丧偶 无子女、128丧偶有子女
     */
    private List<Integer> marriageChildrenRelaxRange;
    /**
     * 婚姻孩子范围名称
     */
    private List<String> marriageChildrenRelaxRangeName;
    /**
     * 籍贯范围  列表 [1,2,3]
     */
    private List<Integer>  nativePlaceRange;

    /**
     * 籍贯范围名称
     */
    private List<String>  nativePlaceNameRange;

    /**
     * 恋爱目标范围  按位或运算 1没考虑清楚、2短期内想结婚、4先认真谈场恋爱、8先认真谈场恋爱，合适可以结婚
     */
    private List<Integer> loveGoalRange;
    /**
     * 恋爱目标范围名称
     */
    private List<String> loveGoalRangeName;

    /**
     * 纹身情况范围 按位或运算 1不介意、2小面积或者隐私部位、4大面积明显部位、8不接受任何纹身
     */
    private List<Integer> tattooStatusRange;
    /**
     * 纹身情况范围名称
     */
    private List<String> tattooStatusRangeName;

    /**
     * 吸烟情况范围 按位或运算 1不介意、2偶尔抽烟、4抽烟、8不接受抽烟
     */
    private List<Integer> smokeStatusRange;
    /**
     * 吸烟情况范围名称
     */
    private List<String> smokeStatusRangeName;

    /**
     * 行业情况 按位或运算 1无所谓、2同行、4非同行
     */
    private List<Integer> industryRange;
    /**
     *  行业情况名称
     */
    private List<String> industryRangeName;

    /**
     * 工作情况 按位或运算 1无所谓、2稳定工作、4创业经商
     */
    private List<Integer> jobRange;

    /**
     * 工作情况名称
     */
    private List<String> jobRangeName;

    /**
     * 生活情况 按位或运算 1无所谓、2顾家、4事业
     */
    private List<Integer> lifeRange;
    /**
     * 生活情况名称
     */
    private List<String> lifeRangeName;

    /**
     * 年收入 按位或运算 1无所谓、2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private List<Integer> yearRevenueRange;
    /**
     * 年收入名称
     */
    private List<String> yearRevenueRangeName;
    /**
     * 车情况 按位或运算 1无所谓、2、有车，4、无车
     */
    private List<Integer> carRange;
    /**
     * 车情况名称
     */
    private List<String> carRangeName;
    /**
     * 房子情况 按位或运算 1无所谓、2、有房，4、无房
     */
    private List<Integer> houseRange;
    /**
     * 房子情况名称
     */
    private List<String> houseRangeName;
    /**
     * 体型
     */
    private List<Integer> bodyShapeRange;
    /**
     * 体型名字
     */
    private List<String> bodyShapeRangeName;

    public List<String> getEduRangeName() {
        return UserConstants.getNameByCode(UserConstants.EduHighestEnum.class, eduRange);
    }

    public List<String> getSchoolRangeName() {
        return UserConstants.getNameByCode(UserConstants.SchoolRangeEnum.class, schoolRange);
    }

    public List<String> getMarriageChildrenRangeName() {
        return UserConstants.getNameByCode(UserConstants.MarriageChildrenStatusEnum.class, marriageChildrenRange);
    }

    public List<String> getMarriageChildrenRelaxRangeName() {
        return UserConstants.getNameByCode(UserConstants.MarriageChildrenRelaxStatusEnum.class, marriageChildrenRelaxRange);
    }

    public List<String> getLoveGoalRangeName() {
        return UserConstants.getNameByCode(UserConstants.LoveGoalEnum.class, loveGoalRange);
    }

    public List<String> getTattooStatusRangeName() {
        return UserConstants.getNameByCode(UserConstants.TattooStatusEnum.class, tattooStatusRange);
    }

    public List<String> getSmokeStatusRangeName() {
        return UserConstants.getNameByCode(UserConstants.SmokeStatusEnum.class, smokeStatusRange);
    }

    public List<String> getIndustryRangeName() {
        return UserConstants.getNameByCode(UserConstants.IndustryRangeEnum.class, industryRange);
    }

    public List<String> getJobRangeName() {
        return UserConstants.getNameByCode(UserConstants.JobRangeEnum.class, jobRange);
    }

    public List<String> getLifeRangeName() {
        return UserConstants.getNameByCode(UserConstants.LifeRangeEnum.class, lifeRange);
    }

    public List<String> getYearRevenueRangeName() {
        return UserConstants.getNameByCode(UserConstants.YearRevenueEnum.class, yearRevenueRange);
    }

    public List<String> getCarRangeName() {
        return UserConstants.getNameByCode(UserConstants.CarEnum.class, carRange);
    }

    public List<String> getHouseRangeName() {
        return UserConstants.getNameByCode(UserConstants.HouseEnum.class, houseRange);
    }

    public List<String> getBodyShapeRangeName() {
        return UserConstants.getNameByCode(UserConstants.BodyShapeEnum.class, bodyShapeRange);
    }
}
