package com.bxm.lovelink.common.dal.entity.vo.user;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户账号信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
public class UserVo {
    private Long id;
    /**
     * 用户编号
     */
    private String userNumber;
    /**
     * uni用户id
     */
    private String uniUserId;
    /**
     * 渠道code
     */
    private String channel;
    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 用户状态 -1 禁用、1 正常
     */
    private Integer status;
    /**
     * 是否注册完成 1是 0 否
     */
    private Integer registerFinished;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    public String getMobile() {
        if (mobile == null || mobile.length() < 11) {
            return mobile;
        }
        return mobile.substring(0, 3) + "****" + mobile.substring(7);
    }

}
