package com.bxm.lovelink.common.dal.entity.vo.visit;


import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 访客列表
 * @author: weixing
 */
@Data
public class UserVisitorListVo {
    /**
     * id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 用户 ID
     */
    private Long userId;

    /**
     * 用户编号
     */
    private String userNumber;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 卡片图
     */
    private String cardImage;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 性别 1-男 0-女
     */
    private Integer gender;

    /**
     * 现居地 市
     */
    private Integer currentPlaceCity;

    /**
     * 现居地城市名称
     */
    private String currentPlaceCityName;
    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;

    /**
     * 工作
     */
    private String job;

    /**
     * 身高 cm
     */
    private Integer height;

    /**
     * 距离，单位：m
     */
    private Integer distance;

    /**
     * 房子情况 2、有房，4、无房
     */
    private Integer house;

    /**
     * 车情况 2、有车，4、无车
     */
    private Integer car;

    /**
     * 是否已读 0-未读 1-已读
     */
    private Integer readStatus;

    /**
     * 删除标识 1-删除 0-正常
     */
    private Integer deleted;

    /**
     * 访问次数
     */
    private Integer visitCount;

    /**
     * 最近访问时间
     */
    private LocalDateTime lastVisitTime;

    /**
     * 获取性别
     */
    public String getGenderName() {
        if (gender == Constants.UserGender.MALE){
            return "他";
        }
        return "她";
    }
}
