package com.bxm.lovelink.common.dal.manager;

import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Allen Hu
 * @date 2025/6/27
 */
@Component
@AllArgsConstructor
public class MeetGroupMessageUnreadCountManager {

    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;
    private final MeetGroupMessageInvalidUnreadCountManager meetGroupMessageInvalidUnreadCountManager;

    public void increment(Long userId, Long meetGroupId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount(userId);
        counter.hincrementAndGet(keyGenerator, meetGroupId.toString());
    }

    public void remove(Long userId, Long meetGroupId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount(userId);
        updater.hremove(keyGenerator, meetGroupId.toString());
    }

    public Long query(Long userId, Long meetGroupId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount(userId);
        return counter.hget(keyGenerator, meetGroupId.toString());
    }

    public Map<String, Integer> queryAll(Long userId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount(userId);
        Map<String, Long> fetchedMap = fetcher.hfetchall(keyGenerator, Long.class);
        if (MapUtils.isEmpty(fetchedMap)) {
            return Collections.emptyMap();
        }
        Map<String, Integer> map = fetchedMap.entrySet().stream()
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        e -> e.getValue().intValue()
                ));
        MeetGroupMessageInvalidUnreadCountManager.QueueItem queueItem = new MeetGroupMessageInvalidUnreadCountManager.QueueItem(userId, map, (waitRemoveItems -> {
            for (MeetGroupMessageInvalidUnreadCountManager.WaitRemoveItem item : waitRemoveItems) {
                Long userId1 = item.getUserId();
                Long meetGroupId = item.getMeetGroupId();
                this.remove(userId1, meetGroupId);
            }
        }));
        meetGroupMessageInvalidUnreadCountManager.add2Queue(queueItem);
        return map;
    }
}
