package com.bxm.lovelink.common.dal.manager.parameter;

import com.bxm.warcar.integration.listeners.AbstractBeanBus;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Allen Hu
 * @date 2025/7/1
 */
@Component
public class ParameterBuilderFactory extends AbstractBeanBus<String, ParameterBuilder> {

    @Override
    protected Class<ParameterBuilder> getInstanceClazz() {
        return ParameterBuilder.class;
    }

    @Override
    protected String getKey(String beanName, ParameterBuilder bean) {
        return bean.key();
    }

    public Map<String, Object> build(ParameterBuilderRequest request) {
        Map<String, Object> parameters = new HashMap<>();
        for (ParameterBuilder consumer : getAll()) {
            String key = consumer.key();
            Object value = consumer.apply(request);
            if (value == null) {
                continue;
            }
            parameters.put(key, value);
        }
        return parameters;
    }
}
